from pydantic import BaseModel, EmailStr
from typing import Optional

class BusinessProfile(BaseModel):
    business_name: str
    business_email: EmailStr
    business_phone: str
    business_address: str
    business_type: str
    business_registration: str
    website_url: Optional[str]
    tax_id: Optional[str]

class PersonalInformation(BaseModel):
    first_name: str
    last_name: str
    email: EmailStr
    phone_number: str
    role: str
    profile_picture_url: Optional[str]

class BillingDetails(BaseModel):
    billing_name: str
    billing_email: EmailStr
    billing_phone: str
    billing_address: str
    payment_method: str
    card_number: str
    card_expiry: str
    card_cvv: str

class AccountSettings(BaseModel):
    business_profile: BusinessProfile
    personal_information: PersonalInformation
    billing_details: BillingDetails
